* This program is to be run on PC
* Note that for each test, outreg spits out the results twice. 
* The first set of results gives the linear sums, while the second lot gives the p-values. 
*
* Note that the P-values are from two-tailed tests. To convert to one-tailed tests, the p-value
* is p/2 or 1-p/2.
* Eg. if H0 is Beta<=0, then p is 1-p/2 if Beta<0, and p/2 if Beta>0.

version 10
clear
program drop _all
set mem 100m
set matsize 800
set more off

* Regressions
cd "C:\Users\Andrew\State & local tax progressivity\"
use stateineq90_cps, clear

tsset stfips year

/*
**************************************************
* Graphs (remove slash-asterisk to make them run)
**************************************************
set scheme s1mono 

* Figure 1
la var gini "Pre-Tax Gini"
twoway scatter gini year if year>1976 & year<2003, ti("Figure 1: Pre-Tax Hourly Wage Inequality by State 1977-2002") note("Source: Author's calculations, from March Current Population Surveys.")

* Figure 2
twoway scatter redist year if year>1976 & year<2003, ti("Figure 2: Redistributive Effect of Taxes by State 1977-2002") note("Source: Author's calculations, from March Current Population Surveys and Taxsim model.")

* Figures 3 & 4
set scheme s1mono
la var gini "Gini (left scale)"
la var redist "Tax redistributivity (right scale)"
la var year "Year"
*twoway (line gini year, yaxis(1)) || (line redist year, yaxis(2)) if year>1976 & year<2003 & state==93, ti("California") ytitle("Gini", axis(1)) ytitle("Tax redistribution (GB-GA)", axis(2)) xtitle("Year") legend(off) saving(ca, replace)
twoway (line gini year, yaxis(1) lpattern(solid)) || (line redist year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==93, ti("California") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(ca, replace)
twoway (line gini year, yaxis(1) lpattern(solid)) || (line redist year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==59, ti("Florida") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(fl, replace)
twoway (line gini year, yaxis(1) lpattern(solid)) || (line redist year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==21, ti("New York") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(ny, replace)
twoway (line gini year, yaxis(1) lpattern(solid)) || (line redist year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==74, ti("Texas") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(tx, replace)
gr combine ca.gph fl.gph ny.gph tx.gph, ycommon title("Figure 3: Pre-Tax Hourly Wage Inequality (solid line, left axis)" "and Tax Redistributivity (dashed line, right axis)") note("Source: Author's calculations, from March Current Population Surveys and Taxsim model.")

bysort year: egen meangini=mean(gini)
bysort year: egen meanredist=mean(redist)
gen ginia=gini-meangini
gen redista=redist-meanredist
twoway (line ginia year, yaxis(1) lpattern(solid)) || (line redista year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==93, ti("California") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(ca, replace)
twoway (line ginia year, yaxis(1) lpattern(solid)) || (line redista year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==59, ti("Florida") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(fl, replace)
twoway (line ginia year, yaxis(1) lpattern(solid)) || (line redista year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==21, ti("New York") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(ny, replace)
twoway (line ginia year, yaxis(1) lpattern(solid)) || (line redista year, yaxis(2) lpattern(dash)) if year>1976 & year<2003 & state==74, ti("Texas") ytitle("", axis(1)) ytitle("", axis(2)) xtitle("") legend(off) saving(tx, replace)
gr combine ca.gph fl.gph ny.gph tx.gph, ycommon title("Figure 4: Pre-Tax Hourly Wage Inequality (solid line, left axis)" "and Tax Redistributivity (dashed line, right axis)" "(Both measured as deviation from annual average)") note("Source: Author's calculations, from March Current Population Surveys and Taxsim model.")

* Figure 5
la var ginipt "Post-Tax Gini"
twoway scatter ginipt year if year>1976 & year<2003, ti("Figure 5: Post-Tax Hourly Wage Inequality by State 1977-2002") ytitle("Post-Tax Gini",margin(small)) note("Source: Author's calculations, from March Current Population Surveys and Taxsim model.")
*/

* Summary stats on changes (for text)
tsset state year
gen d_gini=d.gini
gen d_redist=d.redist
for any d_gini d_redist: sum X, d

* Overall summary statistics
* Dep vars measured 1983-2002
tabstat gini ginipt sg125 sg15 sg25 sg35 inmig_rate outmig_rate wagehr_i wagehr_o pop_non sales_tax inheritance_tax estate_tax_dummy unemploymentrate persinc_percap unionization if year>=1983 , stats(mean sd n) columns(statistics)
* Indep vars measured up to 1977-2002
tabstat redist redist_125 redist_15 redist_25 redist_35, stats(mean sd n) columns(statistics)
* Changes in gini
sum d.gini if year>=1984,d

gen division=. 
gen region=.
for X in num 3 4 4 3 4 4 1 3 3 3 3 4 4 2 2 2 2 3 3 1 3 1 2 2 3 2 4 2 4 1 1 4 1 3 2 2 3 4 1 1 3 2 3 3 4 1 3 4 3 2 4  \ Y in num 6 9 8 7 9 8 1 5 5 5 5 9 8 3 3 4 4 6 7 1 5 1 3 4 6 4 8 4 8 1 2 8 2 5 4 3 7 9 2 1 5 4 6 7 8 1 5 9 5 3 8 \ Z in num 1 2 4 5 6 8 9 10 11 12 13 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 44 45 46 47 48 49 50 51 53 54 55 56: replace region=X if stfips==Z \ replace division=Y if stfips==Z
for num 1/4: gen regionyrX=0 \ replace regionyrX=year-1976 if region==X
*for num 1/9: gen divisionyrX=0 \ replace divisionyrX=year-1976 if division==X

* Setting up regression specifications
program define reg1, eclass
	xi: reg $y $x $controls , r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (all)",_b[$x],"SE (all)",_se[$x],"P_Curr=0",e(c0),"P_All=0",e(c0),"P_Curr=1",e(c1),"P_All=1",e(c1)) ct("$y $x")
end
program define reg2, eclass
	xi: reg $y $x l.$x l2.$x $controls , r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("$y $x")
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("$y $x")
	log using ftests, replace
	test $x l.$x l2.$x 
	test ($x=1) (l.$x=1) (l2.$x=1) 
	log close
end
program define reg3, eclass
	xi: reg $y $x l.$x l2.$x l3.$x l4.$x $controls , r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x+l3.$x+l4.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x+l3.$x+l4.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("$y $x")
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("$y $x")
	log using ftests, append
	test $x l.$x l2.$x l3.$x l4.$x 
	test ($x=1) (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) 
	log close
end
program define reg4, eclass
	xi: reg $y $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls , r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("$y $x")
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("$y $x")
	log using ftests, append
	di "dep var is $y, indep var is $x"
	test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	test ($x=1) (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) (l5.$x=1) (l6.$x=1)
	log close
end

program define reg_reverse, eclass
	xi: reg $y l.$x l2.$x $controls , r cl(stfips) 
	test l.$x+l2.$x=0
	ereturn scalar l0=r(p)
	lincom (l.$x+l2.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2),"P_Lags=0",e(l0)) ct("Reverse: $x $y")
	xi: reg $y l.$x l2.$x l3.$x l4.$x $controls , r cl(stfips) 
	test l.$x+l2.$x+l3.$x+l4.$x=0
	ereturn scalar l0=r(p)
	lincom (l.$x+l2.$x+l3.$x+l4.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2),"P_Lags=0",e(l0)) ct("Reverse: $x $y")
	xi: reg $y l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls , r cl(stfips) 
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar l0=r(p)
	lincom (l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2),"P_Lags=0",e(l0)) ct("Reverse: $x $y")
	log using ftests, append
	di "dep var is $y, indep var is $x"
	test l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	test (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) (l5.$x=1) (l6.$x=1)
	log close
end

program define reg_setup, eclass
	xi: reg $y $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls , r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table1.doc, coefastr nocons bracket 3aster replace bdec(3) adec(3) se addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("DROP")
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) adec(3) se addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("DROP")
end

* Impact on pre-tax inequality
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.stfips i.year if year>=1983"
global y gini
global x redist
* Setting up outreg
reg_setup
* Running regressions
reg1
reg2
test $x l.$x l2.$x 
reg3 
test $x l.$x l2.$x l3.$x l4.$x 
reg4
test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x 

global y sg125
global x redist_125
reg4
global y sg15
global x redist_15
reg4
global y sg25
global x redist_25
reg4
global y sg35
global x redist_35
reg4

* Mobility
global x redist
global y inmig_rate
reg4
global y outmig_rate
reg4
global y wagehr_imnm
reg4
global y wagehr_omnm
reg4
gen dpop=d.pop_noninstitutional
global y dpop 
reg4
global y pop_noninstitutional
reg4
global y ginipt
reg4
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate regionyr1-regionyr4 i.stfips i.year if year>=1983"
global y persinc
reg4

*************************
* Robustness checks
*************************
* Reverse causality
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.stfips i.year if year>=1983"
global y redist
global x gini
reg_reverse

* Pre and post TRA86
global y gini
global x redist
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.stfips i.year if year>=1983 & year<=1985"
reg4
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.stfips i.year if year>=1987"
reg4

* Granger causality
program define reg_granger, eclass
	xi: reg $y l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls, r cl(stfips) 
	test l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	ereturn scalar c0=r(p)
	outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Lags=0",e(c0)) ct("Granger")
end
global y gini
global x redist
global controls "l.gini sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.stfips i.year"
reg_granger

* No time-varying state controls
global controls "regionyr1-regionyr4 i.stfips i.year if year>=1983"
global y gini
global x redist
program define reg4_notvcontrols, eclass
	xi: reg $y $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls , r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table2.doc, coefastr nocons bracket 3aster replace bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("No TV controls - $y $x")
	outreg using table2.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("No TV controls - $y $x")
	log using ftests, append
	di "Table 2 - No time-varying state controls"
	test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	test ($x=1) (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) (l5.$x=1) (l6.$x=1)
	log close
end
reg4_notvcontrols

* Population-weighting
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.stfips i.year if year>=1983"
global y gini
global x redist
gen temp1=exp(pop_non) if year==2002
bysort stfips: egen temp2=max(temp1)
gen wgt=temp2
drop temp*
program define reg_wgt, eclass
	xi: reg $y $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls [aw=wgt], r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	outreg using table2.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("PopWgt $y $x")
	outreg using table2.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("PopWgt $y $x")
	log using ftests, append
	di "Table 2 - Population weighting"
	test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	test ($x=1) (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) (l5.$x=1) (l6.$x=1)
	log close
end
tsset stfips year
reg_wgt

* Without state FE
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.year if year>=1983"
global y gini
global x redist
program define reg_ols,eclass
	xi: reg $y $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls, r cl(stfips) 
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	log using ftests, append
	test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	test ($x=1) (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) (l5.$x=1) (l6.$x=1)
	log close
	outreg using table2.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("OLS - $y $x")
	outreg using table2.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("OLS - $y $x")
	log using ftests, append
	di "Table 2 - No state FE"
	test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	test ($x=1) (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) (l5.$x=1) (l6.$x=1)
	log close
end
reg_ols

* Random effects & Hausman test 
program drop _all
global controls "sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.year if year>=1983"
program define reg_re,eclass
	xi: xtreg $y $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x $controls, re r cl(stfips) i(stfips)
	test $x=0
	ereturn scalar c0=r(p)
	test $x=1
	ereturn scalar c1=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar l0=r(p)
	test l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar l1=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=0
	ereturn scalar b0=r(p)
	test $x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x=1
	ereturn scalar b1=r(p)
	lincom ($x+l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum1=r(estimate)
	ereturn scalar se1=r(se)
	lincom (l.$x+l2.$x+l3.$x+l4.$x+l5.$x+l6.$x) 
	ereturn scalar sum2=r(estimate)
	ereturn scalar se2=r(se)
	test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	outreg using table2.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("Sum (lags)",e(sum2),"SE (lags)",e(se2), "Sum (all)",e(sum1),"SE (all)",e(se1)) ct("RE - $y $x")
	outreg using table2.doc, coefastr nocons bracket 3aster append bdec(3) se adec(3) addstat("P_Curr=0",e(c0),"P_Lags=0",e(l0),"P_All=0",e(b0),"P_Curr=1",e(c1),"P_Lags=1",e(l1),"P_All=1",e(b1)) ct("RE - $y $x")
	log using ftests, append
	di "Table 2 - Random state effects"
	test $x l.$x l2.$x l3.$x l4.$x l5.$x l6.$x
	test ($x=1) (l.$x=1) (l2.$x=1) (l3.$x=1) (l4.$x=1) (l5.$x=1) (l6.$x=1)
	xtoverid
	log close
end
reg_re




STOP

* Just 1983 & 1989
for any redist: xi: reg gini X sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc regionyr1-regionyr4 i.stfips i.year if year==1983 | year==1989, r cl(stfips)
for any redist: xi: reg gini X l6.X sales_tax inheritance_tax estate_tax_dummy unionization unemploymentrate persinc i.stfips i.year if year==1983 | year==1989, r cl(stfips)
for any redist: test X=0 \ test l6.X=0 \ test X+l6.X=0 \ test X=1 \ test l6.X=1 \ test X+l6.X=1

